package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VenvioOs2;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VenvioOs2DaoImpl generated by UDA, 26-jun-2017 10:39:48.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VenvioOs2DaoImpl implements VenvioOs2Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VenvioOs2> rwMap = new RowMapper<VenvioOs2>() {
		public VenvioOs2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VenvioOs2(resultSet.getString("NUMEXP"),
					resultSet.getString("NUMERODOCUMENTO"),
					resultSet.getString("RAZONSOCIAL"),
					resultSet.getString("DIRECCION"),
					resultSet.getLong("PLANTILLA"),
					resultSet.getString("MUNICIPIOEMPRESA"),
					resultSet.getString("TERRITORIOEMPRESA"),
					resultSet.getString("CP"),
					resultSet.getString("TELEFONOEMPRESA"),
					resultSet.getString("FAXEMP"),
					resultSet.getString("EMAEMP"),
					resultSet.getString("HTTPEMP"),
					resultSet.getString("DESCACTIVIDADECONOMICA"),
					resultSet.getString("ACTIVIDADECONOMICA"),
					resultSet.getString("MUNICIPIOCENTRO"),
					resultSet.getString("PROVINCIACENTRO"),
					resultSet.getString("DIRECCIONCENTRO"),
					resultSet.getString("INDANXNO"),
					resultSet.getString("INDANXSI"),
					resultSet.getString("APDOANEXO"),
					resultSet.getString("NUMAPERTURA"),
					resultSet.getString("PIE1"), resultSet.getString("PIE2"),
					resultSet.getString("DESCFIRMA"),
					resultSet.getString("FIRMA"));
		}
	};

	private RowMapper<VenvioOs2> rwMapPK = new RowMapper<VenvioOs2>() {
		public VenvioOs2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VenvioOs2(resultSet.getString("NUMEXP"),
					resultSet.getString("NUMERODOCUMENTO"),
					resultSet.getString("RAZONSOCIAL"),
					resultSet.getString("DIRECCION"),
					resultSet.getLong("PLANTILLA"),
					resultSet.getString("MUNICIPIOEMPRESA"),
					resultSet.getString("TERRITORIOEMPRESA"),
					resultSet.getString("CP"),
					resultSet.getString("TELEFONOEMPRESA"),
					resultSet.getString("FAXEMP"),
					resultSet.getString("EMAEMP"),
					resultSet.getString("HTTPEMP"),
					resultSet.getString("DESCACTIVIDADECONOMICA"),
					resultSet.getString("ACTIVIDADECONOMICA"),
					resultSet.getString("MUNICIPIOCENTRO"),
					resultSet.getString("PROVINCIACENTRO"),
					resultSet.getString("DIRECCIONCENTRO"),
					resultSet.getString("INDANXNO"),
					resultSet.getString("INDANXSI"),
					resultSet.getString("APDOANEXO"),
					resultSet.getString("NUMAPERTURA"),
					resultSet.getString("PIE1"), resultSet.getString("PIE2"),
					resultSet.getString("DESCFIRMA"),
					resultSet.getString("FIRMA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VenvioOs2 table.
	 * 
	 *  venvioos2
	 *            VenvioOs2
	 *  VenvioOs2
	 *
	 * @param venvioos2 the venvioos 2
	 * @return the venvio os 2
	 */
	public VenvioOs2 add(VenvioOs2 venvioos2) {
		String query = "INSERT INTO VENVIO_OS2 (NUMEXP, NUMERODOCUMENTO, RAZONSOCIAL, DIRECCION, PLANTILLA, MUNICIPIOEMPRESA, TERRITORIOEMPRESA, CP, TELEFONOEMPRESA, FAXEMP, EMAEMP, HTTPEMP, DESC_ACTIVIDADECONOMICA, ACTIVIDADECONOMICA, MUNICIPIOCENTRO, PROVINCIACENTRO, DIRECCIONCENTRO, INDANX_NO, INDANX_SI, APDO_ANEXO, NUM_APERTURA, PIE1, PIE2, DESCFIRMA, FIRMA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, venvioos2.getNumexp(),
				venvioos2.getNumerodocumento(), venvioos2.getRazonsocial(),
				venvioos2.getDireccion(), venvioos2.getPlantilla(),
				venvioos2.getMunicipioempresa(),
				venvioos2.getTerritorioempresa(), venvioos2.getCp(),
				venvioos2.getTelefonoempresa(), venvioos2.getFaxemp(),
				venvioos2.getEmaemp(), venvioos2.getHttpemp(),
				venvioos2.getDescActividadeconomica(),
				venvioos2.getActividadeconomica(),
				venvioos2.getMunicipiocentro(), venvioos2.getProvinciacentro(),
				venvioos2.getDireccioncentro(), venvioos2.getIndanxNo(),
				venvioos2.getIndanxSi(), venvioos2.getApdoAnexo(),
				venvioos2.getNumApertura(), venvioos2.getPie1(),
				venvioos2.getPie2(), venvioos2.getDescfirma(),
				venvioos2.getFirma());
		return venvioos2;
	}

	/**
	 * Updates a single row in the VenvioOs2 table.
	 * 
	 *  venvioos2
	 *            VenvioOs2
	 *  VenvioOs2
	 *
	 * @param venvioos2 the venvioos 2
	 * @return the venvio os 2
	 */
	public VenvioOs2 update(VenvioOs2 venvioos2) {
		String query = "UPDATE VENVIO_OS2 SET  WHERE NUMEXP=? AND NUMERODOCUMENTO=? AND RAZONSOCIAL=? AND DIRECCION=? AND PLANTILLA=? AND MUNICIPIOEMPRESA=? AND TERRITORIOEMPRESA=? AND CP=? AND TELEFONOEMPRESA=? AND FAXEMP=? AND EMAEMP=? AND HTTPEMP=? AND DESC_ACTIVIDADECONOMICA=? AND ACTIVIDADECONOMICA=? AND MUNICIPIOCENTRO=? AND PROVINCIACENTRO=? AND DIRECCIONCENTRO=? AND INDANX_NO=? AND INDANX_SI=? AND APDO_ANEXO=? AND NUM_APERTURA=? AND PIE1=? AND PIE2=? AND DESCFIRMA=? AND FIRMA=?";
		this.jdbcTemplate.update(query, venvioos2.getNumexp(),
				venvioos2.getNumerodocumento(), venvioos2.getRazonsocial(),
				venvioos2.getDireccion(), venvioos2.getPlantilla(),
				venvioos2.getMunicipioempresa(),
				venvioos2.getTerritorioempresa(), venvioos2.getCp(),
				venvioos2.getTelefonoempresa(), venvioos2.getFaxemp(),
				venvioos2.getEmaemp(), venvioos2.getHttpemp(),
				venvioos2.getDescActividadeconomica(),
				venvioos2.getActividadeconomica(),
				venvioos2.getMunicipiocentro(), venvioos2.getProvinciacentro(),
				venvioos2.getDireccioncentro(), venvioos2.getIndanxNo(),
				venvioos2.getIndanxSi(), venvioos2.getApdoAnexo(),
				venvioos2.getNumApertura(), venvioos2.getPie1(),
				venvioos2.getPie2(), venvioos2.getDescfirma(),
				venvioos2.getFirma());
		return venvioos2;
	}

	/**
	 * Finds a single row in the VenvioOs2 table.
	 * 
	 *  venvioos2
	 *            VenvioOs2
	 *  VenvioOs2
	 *
	 * @param venvioos2 the venvioos 2
	 * @return the venvio os 2
	 */
	@Transactional(readOnly = true)
	public VenvioOs2 find(VenvioOs2 venvioos2) {
		String query = "SELECT t1.NUMEXP NUMEXP, t1.NUMERODOCUMENTO NUMERODOCUMENTO, t1.RAZONSOCIAL RAZONSOCIAL, t1.DIRECCION DIRECCION, t1.PLANTILLA PLANTILLA, t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA, t1.TERRITORIOEMPRESA TERRITORIOEMPRESA, t1.CP CP, t1.TELEFONOEMPRESA TELEFONOEMPRESA, t1.FAXEMP FAXEMP, t1.EMAEMP EMAEMP, t1.HTTPEMP HTTPEMP, t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA, t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA, t1.MUNICIPIOCENTRO MUNICIPIOCENTRO, t1.PROVINCIACENTRO PROVINCIACENTRO, t1.DIRECCIONCENTRO DIRECCIONCENTRO, t1.INDANX_NO INDANXNO, t1.INDANX_SI INDANXSI, t1.APDO_ANEXO APDOANEXO, t1.NUM_APERTURA NUMAPERTURA, t1.PIE1 PIE1, t1.PIE2 PIE2, t1.DESCFIRMA DESCFIRMA, t1.FIRMA FIRMA FROM VENVIO_OS2 t1  WHERE t1.NUMEXP = ?  ";

		List<VenvioOs2> venvioos2List = this.jdbcTemplate.query(query,
				this.rwMap, venvioos2.getNumexp());
		return (VenvioOs2) DataAccessUtils.uniqueResult(venvioos2List);
	}

	/**
	 * Removes a single row in the VenvioOs2 table.
	 * 
	 *  venvioos2            VenvioOs2
	 *
	 * @param venvioos2 the venvioos 2
	 */
	public void remove(VenvioOs2 venvioos2) {
		String query = "DELETE FROM VENVIO_OS2 WHERE NUMEXP=? AND NUMERODOCUMENTO=? AND RAZONSOCIAL=? AND DIRECCION=? AND PLANTILLA=? AND MUNICIPIOEMPRESA=? AND TERRITORIOEMPRESA=? AND CP=? AND TELEFONOEMPRESA=? AND FAXEMP=? AND EMAEMP=? AND HTTPEMP=? AND DESC_ACTIVIDADECONOMICA=? AND ACTIVIDADECONOMICA=? AND MUNICIPIOCENTRO=? AND PROVINCIACENTRO=? AND DIRECCIONCENTRO=? AND INDANX_NO=? AND INDANX_SI=? AND APDO_ANEXO=? AND NUM_APERTURA=? AND PIE1=? AND PIE2=? AND DESCFIRMA=? AND FIRMA=?";
		this.jdbcTemplate.update(query, venvioos2.getNumexp(),
				venvioos2.getNumerodocumento(), venvioos2.getRazonsocial(),
				venvioos2.getDireccion(), venvioos2.getPlantilla(),
				venvioos2.getMunicipioempresa(),
				venvioos2.getTerritorioempresa(), venvioos2.getCp(),
				venvioos2.getTelefonoempresa(), venvioos2.getFaxemp(),
				venvioos2.getEmaemp(), venvioos2.getHttpemp(),
				venvioos2.getDescActividadeconomica(),
				venvioos2.getActividadeconomica(),
				venvioos2.getMunicipiocentro(), venvioos2.getProvinciacentro(),
				venvioos2.getDireccioncentro(), venvioos2.getIndanxNo(),
				venvioos2.getIndanxSi(), venvioos2.getApdoAnexo(),
				venvioos2.getNumApertura(), venvioos2.getPie1(),
				venvioos2.getPie2(), venvioos2.getDescfirma(),
				venvioos2.getFirma());
	}

	/**
	 * Finds a list of rows in the VenvioOs2 table.
	 * 
	 *  venvioos2
	 *            VenvioOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VenvioOs2>
	 *
	 * @param venvioos2 the venvioos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VenvioOs2> findAll(VenvioOs2 venvioos2,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.PLANTILLA PLANTILLA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.FAXEMP FAXEMP,t1.EMAEMP EMAEMP,t1.HTTPEMP HTTPEMP,t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.INDANX_NO INDANXNO,t1.INDANX_SI INDANXSI,t1.APDO_ANEXO APDOANEXO,t1.NUM_APERTURA NUMAPERTURA,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA ");
		query.append("FROM VENVIO_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(venvioos2);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VenvioOs2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VenvioOs2 table using like.
	 * 
	 *  venvioos2
	 *            VenvioOs2
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VenvioOs2>
	 *
	 * @param venvioos2 the venvioos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VenvioOs2> findAllLike(VenvioOs2 venvioos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.PLANTILLA PLANTILLA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.FAXEMP FAXEMP,t1.EMAEMP EMAEMP,t1.HTTPEMP HTTPEMP,t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.INDANX_NO INDANXNO,t1.INDANX_SI INDANXSI,t1.APDO_ANEXO APDOANEXO,t1.NUM_APERTURA NUMAPERTURA,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA ");
		query.append("FROM VENVIO_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(venvioos2, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VenvioOs2>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VenvioOs2 table.
	 * 
	 *  venvioos2
	 *            VenvioOs2
	 *  Long
	 *
	 * @param venvioos2 the venvioos 2
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VenvioOs2 venvioos2) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VENVIO_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(venvioos2);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VenvioOs2 table using like.
	 * 
	 *  venvioos2
	 *            VenvioOs2
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param venvioos2 the venvioos 2
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VenvioOs2 venvioos2, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VENVIO_OS2 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(venvioos2, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VenvioOs2 selected for rup_table.
	 * 
	 *  venvioos2            VenvioOs2
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VenvioOs2>>
	 *
	 * @param venvioos2 the venvioos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VenvioOs2>> reorderSelection(VenvioOs2 venvioos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.PLANTILLA PLANTILLA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.FAXEMP FAXEMP,t1.EMAEMP EMAEMP,t1.HTTPEMP HTTPEMP,t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.INDANX_NO INDANXNO,t1.INDANX_SI INDANXSI,t1.APDO_ANEXO APDOANEXO,t1.NUM_APERTURA NUMAPERTURA,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA ");
		// FROM
		query.append("FROM VENVIO_OS2 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(venvioos2, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(
						query,
						jqGridRequestDto,
						VenvioOs2.class,
						filterParamList,
						"NUMEXP,NUMERODOCUMENTO,RAZONSOCIAL,DIRECCION,PLANTILLA,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CP,TELEFONOEMPRESA,FAXEMP,EMAEMP,HTTPEMP,DESC_ACTIVIDADECONOMICA,ACTIVIDADECONOMICA,MUNICIPIOCENTRO,PROVINCIACENTRO,DIRECCIONCENTRO,INDANX_NO,INDANX_SI,APDO_ANEXO,NUM_APERTURA,PIE1,PIE2,DESCFIRMA,FIRMA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VenvioOs2>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            VenvioOs2
	 *  searchParams            VenvioOs2
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VenvioOs2>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VenvioOs2>> search(VenvioOs2 filterParams,
			VenvioOs2 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.PLANTILLA PLANTILLA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.FAXEMP FAXEMP,t1.EMAEMP EMAEMP,t1.HTTPEMP HTTPEMP,t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.INDANX_NO INDANXNO,t1.INDANX_SI INDANXSI,t1.APDO_ANEXO APDOANEXO,t1.NUM_APERTURA NUMAPERTURA,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA ");
		// FROM
		query.append("FROM VENVIO_OS2 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(
						query,
						jqGridRequestDto,
						VenvioOs2.class,
						filterParamList,
						searchSQL,
						searchParamList,
						from_alias,
						"NUMEXP,NUMERODOCUMENTO,RAZONSOCIAL,DIRECCION,PLANTILLA,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CP,TELEFONOEMPRESA,FAXEMP,EMAEMP,HTTPEMP,DESC_ACTIVIDADECONOMICA,ACTIVIDADECONOMICA,MUNICIPIOCENTRO,PROVINCIACENTRO,DIRECCIONCENTRO,INDANX_NO,INDANX_SI,APDO_ANEXO,NUM_APERTURA,PIE1,PIE2,DESCFIRMA,FIRMA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VenvioOs2>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filtervenvioos2            VenvioOs2
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filtervenvioos2 the filtervenvioos 2
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(VenvioOs2 filtervenvioos2,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMERODOCUMENTO NUMERODOCUMENTO,t1.RAZONSOCIAL RAZONSOCIAL,t1.DIRECCION DIRECCION,t1.PLANTILLA PLANTILLA,t1.MUNICIPIOEMPRESA MUNICIPIOEMPRESA,t1.TERRITORIOEMPRESA TERRITORIOEMPRESA,t1.CP CP,t1.TELEFONOEMPRESA TELEFONOEMPRESA,t1.FAXEMP FAXEMP,t1.EMAEMP EMAEMP,t1.HTTPEMP HTTPEMP,t1.DESC_ACTIVIDADECONOMICA DESCACTIVIDADECONOMICA,t1.ACTIVIDADECONOMICA ACTIVIDADECONOMICA,t1.MUNICIPIOCENTRO MUNICIPIOCENTRO,t1.PROVINCIACENTRO PROVINCIACENTRO,t1.DIRECCIONCENTRO DIRECCIONCENTRO,t1.INDANX_NO INDANXNO,t1.INDANX_SI INDANXSI,t1.APDO_ANEXO APDOANEXO,t1.NUM_APERTURA NUMAPERTURA,t1.PIE1 PIE1,t1.PIE2 PIE2,t1.DESCFIRMA DESCFIRMA,t1.FIRMA FIRMA ");
		// FROM
		query.append("FROM VENVIO_OS2 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtervenvioos2,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(
						jqGridRequestDto,
						VenvioOs2.class,
						query,
						params,
						"NUMEXP,NUMERODOCUMENTO,RAZONSOCIAL,DIRECCION,PLANTILLA,MUNICIPIOEMPRESA,TERRITORIOEMPRESA,CP,TELEFONOEMPRESA,FAXEMP,EMAEMP,HTTPEMP,DESC_ACTIVIDADECONOMICA,ACTIVIDADECONOMICA,MUNICIPIOCENTRO,PROVINCIACENTRO,DIRECCIONCENTRO,INDANX_NO,INDANX_SI,APDO_ANEXO,NUM_APERTURA,PIE1,PIE2,DESCFIRMA,FIRMA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VenvioOs2 entity.
	 * 
	 *  venvioos2            VenvioOs2 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param venvioos2 the venvioos 2
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VenvioOs2 venvioos2) {

		StringBuilder where = new StringBuilder(
				VenvioOs2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (venvioos2 != null && venvioos2.getNumexp() != null) {
			where.append(" AND t1.NUMEXP = ?");
			params.add(venvioos2.getNumexp());
		}
		if (venvioos2 != null && venvioos2.getNumerodocumento() != null) {
			where.append(" AND t1.NUMERODOCUMENTO = ?");
			params.add(venvioos2.getNumerodocumento());
		}
		if (venvioos2 != null && venvioos2.getRazonsocial() != null) {
			where.append(" AND t1.RAZONSOCIAL = ?");
			params.add(venvioos2.getRazonsocial());
		}
		if (venvioos2 != null && venvioos2.getDireccion() != null) {
			where.append(" AND t1.DIRECCION = ?");
			params.add(venvioos2.getDireccion());
		}
		if (venvioos2 != null && venvioos2.getPlantilla() != null) {
			where.append(" AND t1.PLANTILLA = ?");
			params.add(venvioos2.getPlantilla());
		}
		if (venvioos2 != null && venvioos2.getMunicipioempresa() != null) {
			where.append(" AND t1.MUNICIPIOEMPRESA = ?");
			params.add(venvioos2.getMunicipioempresa());
		}
		if (venvioos2 != null && venvioos2.getTerritorioempresa() != null) {
			where.append(" AND t1.TERRITORIOEMPRESA = ?");
			params.add(venvioos2.getTerritorioempresa());
		}
		if (venvioos2 != null && venvioos2.getCp() != null) {
			where.append(" AND t1.CP = ?");
			params.add(venvioos2.getCp());
		}
		if (venvioos2 != null && venvioos2.getTelefonoempresa() != null) {
			where.append(" AND t1.TELEFONOEMPRESA = ?");
			params.add(venvioos2.getTelefonoempresa());
		}
		if (venvioos2 != null && venvioos2.getFaxemp() != null) {
			where.append(" AND t1.FAXEMP = ?");
			params.add(venvioos2.getFaxemp());
		}
		if (venvioos2 != null && venvioos2.getEmaemp() != null) {
			where.append(" AND t1.EMAEMP = ?");
			params.add(venvioos2.getEmaemp());
		}
		if (venvioos2 != null && venvioos2.getHttpemp() != null) {
			where.append(" AND t1.HTTPEMP = ?");
			params.add(venvioos2.getHttpemp());
		}
		if (venvioos2 != null && venvioos2.getDescActividadeconomica() != null) {
			where.append(" AND t1.DESC_ACTIVIDADECONOMICA = ?");
			params.add(venvioos2.getDescActividadeconomica());
		}
		if (venvioos2 != null && venvioos2.getActividadeconomica() != null) {
			where.append(" AND t1.ACTIVIDADECONOMICA = ?");
			params.add(venvioos2.getActividadeconomica());
		}
		if (venvioos2 != null && venvioos2.getMunicipiocentro() != null) {
			where.append(" AND t1.MUNICIPIOCENTRO = ?");
			params.add(venvioos2.getMunicipiocentro());
		}
		if (venvioos2 != null && venvioos2.getProvinciacentro() != null) {
			where.append(" AND t1.PROVINCIACENTRO = ?");
			params.add(venvioos2.getProvinciacentro());
		}
		if (venvioos2 != null && venvioos2.getDireccioncentro() != null) {
			where.append(" AND t1.DIRECCIONCENTRO = ?");
			params.add(venvioos2.getDireccioncentro());
		}
		if (venvioos2 != null && venvioos2.getIndanxNo() != null) {
			where.append(" AND t1.INDANX_NO = ?");
			params.add(venvioos2.getIndanxNo());
		}
		if (venvioos2 != null && venvioos2.getIndanxSi() != null) {
			where.append(" AND t1.INDANX_SI = ?");
			params.add(venvioos2.getIndanxSi());
		}
		if (venvioos2 != null && venvioos2.getApdoAnexo() != null) {
			where.append(" AND t1.APDO_ANEXO = ?");
			params.add(venvioos2.getApdoAnexo());
		}
		if (venvioos2 != null && venvioos2.getNumApertura() != null) {
			where.append(" AND t1.NUM_APERTURA = ?");
			params.add(venvioos2.getNumApertura());
		}
		if (venvioos2 != null && venvioos2.getPie1() != null) {
			where.append(" AND t1.PIE1 = ?");
			params.add(venvioos2.getPie1());
		}
		if (venvioos2 != null && venvioos2.getPie2() != null) {
			where.append(" AND t1.PIE2 = ?");
			params.add(venvioos2.getPie2());
		}
		if (venvioos2 != null && venvioos2.getDescfirma() != null) {
			where.append(" AND t1.DESCFIRMA = ?");
			params.add(venvioos2.getDescfirma());
		}
		if (venvioos2 != null && venvioos2.getFirma() != null) {
			where.append(" AND t1.FIRMA = ?");
			params.add(venvioos2.getFirma());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VenvioOs2 entity.
	 * 
	 *  venvioos2            VenvioOs2 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param venvioos2 the venvioos 2
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(VenvioOs2 venvioos2,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VenvioOs2DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (venvioos2 != null && venvioos2.getNumexp() != null) {
			where.append(" AND UPPER(t1.NUMEXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getNumexp().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getNumexp().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMEXP IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getNumerodocumento() != null) {
			where.append(" AND UPPER(t1.NUMERODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getNumerodocumento().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getNumerodocumento().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.NUMERODOCUMENTO IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getRazonsocial() != null) {
			where.append(" AND UPPER(t1.RAZONSOCIAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getRazonsocial().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getRazonsocial().toUpperCase() + "%");
			}
			where.append(" AND t1.RAZONSOCIAL IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getDireccion() != null) {
			where.append(" AND UPPER(t1.DIRECCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getDireccion().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getDireccion().toUpperCase() + "%");
			}
			where.append(" AND t1.DIRECCION IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getPlantilla() != null) {
			where.append(" AND t1.PLANTILLA = ?");
			params.add(venvioos2.getPlantilla());
		}
		if (venvioos2 != null && venvioos2.getMunicipioempresa() != null) {
			where.append(" AND UPPER(t1.MUNICIPIOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getMunicipioempresa().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getMunicipioempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MUNICIPIOEMPRESA IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getTerritorioempresa() != null) {
			where.append(" AND UPPER(t1.TERRITORIOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getTerritorioempresa().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getTerritorioempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TERRITORIOEMPRESA IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getCp() != null) {
			where.append(" AND UPPER(t1.CP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getCp().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getCp().toUpperCase() + "%");
			}
			where.append(" AND t1.CP IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getTelefonoempresa() != null) {
			where.append(" AND UPPER(t1.TELEFONOEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getTelefonoempresa().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getTelefonoempresa().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TELEFONOEMPRESA IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getFaxemp() != null) {
			where.append(" AND UPPER(t1.FAXEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getFaxemp().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getFaxemp().toUpperCase() + "%");
			}
			where.append(" AND t1.FAXEMP IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getEmaemp() != null) {
			where.append(" AND UPPER(t1.EMAEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getEmaemp().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getEmaemp().toUpperCase() + "%");
			}
			where.append(" AND t1.EMAEMP IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getHttpemp() != null) {
			where.append(" AND UPPER(t1.HTTPEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getHttpemp().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getHttpemp().toUpperCase() + "%");
			}
			where.append(" AND t1.HTTPEMP IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getDescActividadeconomica() != null) {
			where.append(" AND UPPER(t1.DESC_ACTIVIDADECONOMICA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getDescActividadeconomica().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ venvioos2.getDescActividadeconomica().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESC_ACTIVIDADECONOMICA IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getActividadeconomica() != null) {
			where.append(" AND UPPER(t1.ACTIVIDADECONOMICA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getActividadeconomica().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ venvioos2.getActividadeconomica().toUpperCase() + "%");
			}
			where.append(" AND t1.ACTIVIDADECONOMICA IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getMunicipiocentro() != null) {
			where.append(" AND UPPER(t1.MUNICIPIOCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getMunicipiocentro().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getMunicipiocentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.MUNICIPIOCENTRO IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getProvinciacentro() != null) {
			where.append(" AND UPPER(t1.PROVINCIACENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getProvinciacentro().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getProvinciacentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.PROVINCIACENTRO IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getDireccioncentro() != null) {
			where.append(" AND UPPER(t1.DIRECCIONCENTRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getDireccioncentro().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getDireccioncentro().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DIRECCIONCENTRO IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getIndanxNo() != null) {
			where.append(" AND UPPER(t1.INDANX_NO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getIndanxNo().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getIndanxNo().toUpperCase() + "%");
			}
			where.append(" AND t1.INDANX_NO IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getIndanxSi() != null) {
			where.append(" AND UPPER(t1.INDANX_SI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getIndanxSi().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getIndanxSi().toUpperCase() + "%");
			}
			where.append(" AND t1.INDANX_SI IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getApdoAnexo() != null) {
			where.append(" AND UPPER(t1.APDO_ANEXO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getApdoAnexo().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getApdoAnexo().toUpperCase() + "%");
			}
			where.append(" AND t1.APDO_ANEXO IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getNumApertura() != null) {
			where.append(" AND UPPER(t1.NUM_APERTURA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getNumApertura().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getNumApertura().toUpperCase() + "%");
			}
			where.append(" AND t1.NUM_APERTURA IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getPie1() != null) {
			where.append(" AND UPPER(t1.PIE1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getPie1().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getPie1().toUpperCase() + "%");
			}
			where.append(" AND t1.PIE1 IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getPie2() != null) {
			where.append(" AND UPPER(t1.PIE2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getPie2().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getPie2().toUpperCase() + "%");
			}
			where.append(" AND t1.PIE2 IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getDescfirma() != null) {
			where.append(" AND UPPER(t1.DESCFIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getDescfirma().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getDescfirma().toUpperCase() + "%");
			}
			where.append(" AND t1.DESCFIRMA IS NOT NULL");
		}
		if (venvioos2 != null && venvioos2.getFirma() != null) {
			where.append(" AND UPPER(t1.FIRMA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(venvioos2.getFirma().toUpperCase() + "%");
			} else {
				params.add("%" + venvioos2.getFirma().toUpperCase() + "%");
			}
			where.append(" AND t1.FIRMA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
